import shlex
from io import StringIO


class Key:
    def __init__(self, key):
        self._pairs = []

        lexer = shlex.shlex(StringIO(key))
        lexer.commenters = ''
        lexer.wordchars += "-"

        while True:
            key = lexer.get_token()
            if key == lexer.eof:
                break

            optional = False
            private = False
            while True:
                tok = lexer.get_token()
                if tok == "=":
                    lexer.whitespace_split = True
                    value = lexer.get_token()
                    lexer.whitespace_split = False
                    value = shlex.split(value)[0]
                    self._pairs.append(Pair(key, value, optional, private))
                    break
                elif tok == "!":
                    private = True
                elif tok == "?":
                    optional = True
                else:
                    lexer.push_token(tok)
                    self._pairs.append(Pair(key, None, optional, private))
                    break

    def __str__(self):
        res = ""
        for i in range(len(self._pairs)):
            pair = self._pairs[i]
            res += pair.key
            if pair.optional:
                res += "?"
            if pair.private:
                res += "!"
            if pair.value is not None:
                res += "=" + shlex.quote(pair.value)
            if i + 1 < len(self._pairs):
                res += " "
        return res

    def __repr__(self):
        return f"<{str(self)}>"

    def __iter__(self):
        return iter(self._pairs)


class Pair:
    def __init__(self, key, value=None, optional=False, private=False):
        self.key = key
        self.value = value
        self.optional = optional
        self.private = private
