import argparse
import os
import gi

from himitsu_gtk.window import KeyringWindow

gi.require_version('Gtk', '3.0')
from gi.repository import Gtk, Gio

gi.require_version('Handy', '1')
from gi.repository import Handy


class KeyringApplication(Gtk.Application):
    def __init__(self, application_id, flags, args, version):
        Gtk.Application.__init__(self, application_id=application_id, flags=flags)
        self.connect("activate", self.new_window)
        self.args = args
        self.version = version

    def new_window(self, *args):
        KeyringWindow(self, self.args, self.version)


def main(version):
    Handy.init()

    parser = argparse.ArgumentParser(description="Himitsu GTK keyring tool")
    args = parser.parse_args()

    if os.path.isfile('himitsu_gtk/keyring.gresource'):
        print("Using resources from cwd/talk")
        resource = Gio.resource_load("himitsu_gtk/keyring.gresource")
        Gio.Resource._register(resource)
    elif os.path.isfile('keyring.gresource'):
        print("Using resources from cwd")
        resource = Gio.resource_load("keyring.gresource")
        Gio.Resource._register(resource)

    app = KeyringApplication("nl.brixit.Keyring", Gio.ApplicationFlags.FLAGS_NONE, args=args,
                             version=version)
    app.run()


if __name__ == '__main__':
    main('development')
